<?php
/**
 * Classe du formulaire de configuration du module de création du flux
 * d'articles pour l'infolettre
 */

namespace Drupal\dgsi_json_feed\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Entity\EntityFieldManager;

class SettingsForm extends ConfigFormBase {

  public function getFormId() {
    return 'dgsi_json_feed_admin_form';
  }

  protected function getEditableConfigNames() {
    return ['dgsi_json_feed.settings'];
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('dgsi_json_feed.settings');

    $form['node_type'] = [
      '#type' => 'select',
      '#title' => $this->t("Type de contenu à envoyer dans le flux"),
      '#default_value' => $config->get('node_type') ?: '',
      '#placeholder' => $this->t("Sélectionnez un type de contenu"),
      '#description' => $this->t("Sélectionnez le type de contenu à envoyer dans le flux d'articles"),
      '#empty_option' => $this->t("- Sélectionnez un type de contenu -"),
      '#options' => node_type_get_names(),
      '#required' => TRUE,
      '#ajax' => [
        'event' => 'change',
        'callback' => '::NodeTypeSelectCallback',
        'wrapper' => 'field-image-wrapper',
      ],
    ];

    $form['image_field_name'] = [
      '#type' => 'select',
      '#title' => $this->t("Champ contenant l'image d'illustration"),
      '#default_value' => $config->get('image_field_name') ?: '',
      '#description' => $this->t("Sélectionnez le champ contenant l'image d'illustration."),
      '#empty_option' => $this->t("- Sélectionnez le champ -"),
      '#options' => $this->loadImageFieldsForNodeType($form_state->getValue('node_type')),
      '#prefix' => '<div id="field-image-wrapper">',
      '#suffix' => '</div>',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  public static function loadImageFieldsForNodeType($node_type) {
    if (!empty($node_type)) {
      $imageFields = \Drupal::service('entity_field.manager')
        ->getFieldMapByFieldType('image');

      $options = [];
      foreach ($imageFields['node'] as $field_name => $field_info) {
        if (in_array($node_type, $field_info['bundles'])) {
          $options[$field_name] = $field_name;
        }
      }

      return $options;
    } else {
      return [];
    }
  }

  public function NodeTypeSelectCallback(array $form, FormStateInterface $form_state) {
    return $form['image_field_name'];
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory->getEditable('dgsi_json_feed.settings');
    $config->set('node_type', $form_state->getValue('node_type'));
    $config->set('image_field_name', $form_state->getValue('image_field_name'));
    $config->save();

    return parent::submitForm($form, $form_state);
  }
}