<?php

namespace Drupal\dgsi_json_feed\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Language\Language;
use Drupal\file\Entity\File;
use Drupal\image\Entity\ImageStyle;
use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\JsonResponse;

class FeedController extends ControllerBase {

  public function getJsonFeed($langcode) {
    $config = $this->config('dgsi_json_feed.settings');

    $range = !empty($_GET['per_page']) ? $_GET['per_page'] : 20;

    $nids = \Drupal::entityQuery('node')
      ->range(0, $range)
      ->condition('type',$config->get('node_type'))
      ->condition('status', 1)
      ->sort('created', 'DESC')
      ->execute();

    $articles = [];
    $imgStyle1Col = ImageStyle::load('thumbnail_infolettre_1col');
    $imgStyle2Cols = ImageStyle::load('thumbnail_infolettre_2cols');
    $imgStyle3Cols = ImageStyle::load('thumbnail_infolettre_3cols');
    foreach($nids as $nid) {
      $node = Node::load($nid);

      $translation = $langcode != Language::LANGCODE_NOT_SPECIFIED &&
        $node->hasTranslation($langcode) ?
        $node->getTranslation($langcode) : $node;

      $title = $translation->get('title')->value;
      $excerpt = !empty($translation->get('body')->summary) ?
        $translation->get('body')->summary :
        strip_tags($translation->get('body')->value);
      $imageFieldName = $config->get('image_field_name');
      $imageFieldUri = $this->_get_file_field_uri($translation, $imageFieldName);

      if (strlen($title) >= 50) {
        $pos = strpos($title, ' ', 50) > 0 ?
          strpos($title, ' ', 50) : 50;
        $title = substr($title, 0, $pos) . "...";
      }

      if (strlen($excerpt) >= 200) {
        $pos = strpos($excerpt, ' ', 194);
        $excerpt = substr($excerpt, 0, $pos) . " [...]";
      }

      $article = [
        'date' => date('Y-m-d\TH:i:s', $node->getCreatedTime()),
        'title' => [
          'rendered' => htmlentities($title, ENT_SUBSTITUTE),
        ],
        'featured_media' => [
          'sizes' => [
            '_1col'  => $imgStyle1Col->buildUrl($imageFieldUri),
            '_2cols' => $imgStyle2Cols->buildUrl($imageFieldUri),
            '_3cols' => $imgStyle3Cols->buildUrl($imageFieldUri),
          ],
        ],
        'excerpt' => [
          'rendered' => htmlentities($excerpt, ENT_SUBSTITUTE),
        ],
        'link' => $GLOBALS['base_url'] .
          \Drupal::service('path_alias.manager')
            ->getAliasByPath('/node/' . $nid, $langcode),
      ];

      $articles[] = $article;
    }

    return new JsonResponse($articles);
  }

  public function getPost($langcode, $nid) {
    $config = $this->config('dgsi_json_feed.settings');

    $imgStyle1Col = ImageStyle::load('thumbnail_infolettre_1col');
    $imgStyle2Cols = ImageStyle::load('thumbnail_infolettre_2cols');
    $imgStyle3Cols = ImageStyle::load('thumbnail_infolettre_3cols');

    $node = Node::load($nid);

    if(!empty($node)) {

      $translation = $langcode != Language::LANGCODE_NOT_SPECIFIED && $node->hasTranslation($langcode)
        ? $node->getTranslation($langcode)
        : $node;

      $title = $translation->get('title')->value;
      $excerpt = !empty($translation->get('body')->summary) ? $translation->get('body')->summary : strip_tags($translation->get('body')->value);
      $imageFieldName = $config->get('image_field_name');
      $imageFieldUri = $this->_get_file_field_uri($translation, $imageFieldName);

      if (strlen($title) >= 50) {
        $pos = strpos($title, ' ', 50) > 0 ? strpos($title, ' ', 50) : 50;
        $title = substr($title, 0, $pos) . "...";
      }

      if (strlen($excerpt) >= 200) {
        $pos = strpos($excerpt, ' ', 194);
        $excerpt = substr($excerpt, 0, $pos) . " [...]";
      }

      $article = [
        'date' => date('Y-m-d\TH:i:s', $node->getCreatedTime()),
        'title' => [
          'rendered' => htmlentities($title, ENT_SUBSTITUTE),
        ],
        'featured_media' => [
          'sizes' => [
            '_1col' => $imgStyle1Col->buildUrl($imageFieldUri),
            '_2cols' => $imgStyle2Cols->buildUrl($imageFieldUri),
            '_3cols' => $imgStyle3Cols->buildUrl($imageFieldUri),
          ],
        ],
        'excerpt' => [
          'rendered' => htmlentities($excerpt, ENT_SUBSTITUTE),
        ],
        'link' => $GLOBALS['base_url'] . \Drupal::service('path_alias.manager')
            ->getAliasByPath('/node/' . $nid, $langcode),
      ];
    } else {
      $article = [];
    }

    return new JsonResponse($article);
  }

  function _get_file_field_uri($entity, $fieldName) {
    $image_uri = NULL;

    if( $entity->hasField($fieldName) ) {
      // Try loading from field values first.
      try {
        $field = $entity->{$fieldName};

        if ($field && $field->target_id) {
          $file = File::load($field->target_id);

          if ($file) {
            $image_uri = $file->getFileUri();
          }
        }
      }
      catch (\Exception $e) {
        \Drupal::logger('get_image_uri')->notice($e->getMessage(), []);
      }

      // If a set value above wasn't found, try the default image.
      if (is_null($image_uri)) {
        try {
          $field = $entity->get($fieldName);

          if ($field) {
            $default_image = $field->getSetting('default_image');

            if ($default_image && $default_image['uuid']) {
              $entity_repository = Drupal::service('entity.repository');

              /** @var $defaultImageFile File */
              $defaultImageFile = $entity_repository->loadEntityByUuid('file', $default_image['uuid']);

              if ($defaultImageFile) {
                $image_uri = $defaultImageFile->getFileUri();
              }
            }
          }
        }
        catch (\Exception $e) {
          \Drupal::logger('get_image_uri')->notice($e->getMessage(), []);
        }
      }
    }

    return $image_uri;
  }

}