<?php

/**
 * Function for handling ajax request
 */
function dgsi_json_feed_dropdown_image_field($form, $form_state) {
  // Return the dropdown list including the wrapper
  return $form['dgsi_json_feed']['wrapper'];
}

/**
 * Implements hook_admin().
 */
function dgsi_json_feed_admin($form, &$form_state) {
  
  // Content type dropdown list
  $form['dgsi_json_feed']['dgsi_json_feed_content_type'] = array(
    '#type' => 'select',
    '#title' => t('Content type'),
    '#description' => t('Select the content type to return in the feed'),
    '#default_value' => variable_get('dgsi_json_feed_content_type', ''),
    '#empty_option' => t('- Select the content type -'),
    '#options' => node_type_get_names(),
    '#required' => true,
    '#ajax' => array(
      'event'=>'change',
      'callback' =>'dgsi_json_feed_dropdown_image_field',
      'wrapper' => 'field-wrapper',
    ),
  );
  
  // Wrapper for field dropdown list
  $form['dgsi_json_feed']['wrapper'] = array(
    '#prefix' => '<div id="field-wrapper">',
    '#suffix' => '</div>',
  );
  
  // Options for field dropdown list
  $options = array('');
  if (isset($form_state['values']['dgsi_json_feed_content_type'])) {
    // Pre-populate options for image_field dropdown list if content_type id is set
    $options = _dgsi_json_feed_fields_by_type_by_bundle($form_state['values']['dgsi_json_feed_content_type']);
  }
  
  // Field dropdown list
  $form['dgsi_json_feed']['wrapper']['dgsi_json_feed_image_field'] = array(
    '#type' => 'select',
    '#title' => t('Image Field'),
    '#description' => t('Select the featured image field.'),
    '#default_value' => variable_get('dgsi_json_feed_image_field', ''),
    '#empty_option' => t('- Select the image field -'),
    '#options' => $options,
    '#required' => true,
  );
  
  return system_settings_form($form);
}

/**
 * Helper function to return all fields of one type on one bundle.
 */
function _dgsi_json_feed_fields_by_type_by_bundle($bundle, $entity_type = 'node', $type = 'image') {
  $chosen_fields = array();
  $fields = field_info_field_map();
  foreach ($fields as $field => $info) {
    if ($info['type'] == $type &&
      in_array($entity_type, array_keys($info['bundles'])) &&
      in_array($bundle, $info['bundles'][$entity_type]))
    {
      $chosen_fields[$field] = $field;
    }
  }
  return $chosen_fields;
}

/**
 * Implements hook_form_FORM_ID_alter().
 */
function dgsi_json_feed_form_dgsi_json_feed_admin_alter(&$form, $form_state, $form_id) {
  $content_type = variable_get('dgsi_json_feed_content_type', '');
  // Initialisation du select au chargement du formulaire si la config existe
  if (!empty($content_type) && !isset($form_state['values']['dgsi_json_feed_content_type'])) {
    $form['dgsi_json_feed']['wrapper']['dgsi_json_feed_image_field']['#options'] =
      _dgsi_json_feed_fields_by_type_by_bundle($content_type);
  }
}
